﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport marży dla zakupu</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
		<script runat="server">

			public class ParametryContext : ContextBase
			{
				private bool _ignorujZaliczkowe = true;
				private bool _raportowacKwpz = false;

				public ParametryContext(Context cx)
					: base(cx)
				{ }

				[Soneta.Tools.Priority(1)]
				public bool IgnorujZaliczkowe
				{
					get
					{
						return this._ignorujZaliczkowe;
					}
					set
					{
						this._ignorujZaliczkowe = value;
						OnChanged(EventArgs.Empty);
					}
				}
				[Soneta.Tools.Priority(2)]
				[Soneta.Types.Caption(@"Raportować KWPZ")]
				public bool RaportowacKwpz
				{
					get
					{
						return this._raportowacKwpz;
					}
					set
					{
						this._raportowacKwpz = value;
						OnChanged(EventArgs.Empty);
					}
				}
			}

			ParametryContext parametry;

			[Context]
			public ParametryContext Parametry
			{
				get
				{
					return parametry;
				}
				set
				{
					parametry = value;
				}
			}

			void dc_ContextLoad(object sender, EventArgs args)
			{
				ListaKWPZ.Visible = this.Parametry.RaportowacKwpz;

				if (this.Parametry.RaportowacKwpz)
				{
					this.LoadKWPZ();
				}
			}	
			private void Grid_BeforeRow(Object sender, RowEventArgs args)
			{
				DokumentHandlowy dok = (DokumentHandlowy)args.Row;
                args.VisibleRow = !dok.Anulowany;
				if (this.Parametry.IgnorujZaliczkowe)
				{
					args.VisibleRow = dok.Definicja.EdycjaWartosci != EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę && !dok.Anulowany;
				}
				args.VisibleRow = (decimal)ColWartZakupu.EditValue != 0m;
			}
			#region Lista KWPZ.

			private void LoadKWPZ()
			{
				HandelModule hm = HandelModule.GetInstance(dc);

				SubTable st;

				Magazyn magazyn = (Magazyn)dc[typeof(Magazyn)];
				if (magazyn == null)
					st = hm.DokHandlowe.WgDaty;
				else
					st = hm.DokHandlowe.WgMagazyn[magazyn];

				Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
					dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
				st = new SubTable(st, pars.Okres);

			Soneta.Business.View vwk = st.CreateView();
				vwk.Condition &= new FieldCondition.Equal("Definicja", hm.DefDokHandlowych.KorektaPZWZ);

				GridKor.DataSource = vwk;
			}

			protected void GridKor_BeforeRow(object sender, RowEventArgs args)
			{
				DokumentHandlowy dok = (DokumentHandlowy)args.Row;
				if (dok.Anulowany || !testDok(dok))
					args.VisibleRow = false;
			}

			bool testDok(DokumentHandlowy dok)
			{
				foreach (DokumentHandlowy pz in dok.Nadrzędne)
				{
					if (pz.Definicja == dok.Module.DefDokHandlowych.KorektaPZWZ)
					{
						if (testDok(pz)) return true;
					}
					else if (pz.KierunekMagazynu == KierunekPartii.Przychód)
					{
						if (JestHandlowy(pz) || pz.DokumentyHandlowe.Length > 0) return true;
					}
				}
				return false;
			}
			private static bool JestHandlowy(DokumentHandlowy dok)
			{
				return KategoriaHandlowa.HandelPierwszy <= dok.Kategoria && dok.Kategoria <= KategoriaHandlowa.HandelOstatni;
			}
			void GridKor_AfterRender(Object sender, EventArgs args)
			{
				decimal v = ColZakupNettoK.TotalValue == null ? 0 : (decimal)ColZakupNettoK.TotalValue;
                v += ColWartZakupu.TotalValue == null ? 0 : (decimal)ColWartZakupu.TotalValue;
				ZakupyRazemLabel.EditValue = v;

				decimal vs = 0m;
                vs += ColWartSprzed.TotalValue == null ? 0 : (decimal)ColWartSprzed.TotalValue;
				ZyskRazemLabel.EditValue = vs - v;

				if (vs != 0)
					MarzaRazemLabel.EditValue = new Percent((vs - v) / vs);
				else
					MarzaRazemLabel.EditValue = Percent.Blank;

				if (v != 0)
					NarzutRazemLabel.EditValue = new Percent((vs - v) / v);
				else
					NarzutRazemLabel.EditValue = Percent.Blank;
			}

			#endregion	
		</script>
	</head>
	<body>
		<form method="post" runat="server" action="#">
			<p>
				<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext><eb:reportheader id="ReportHeader" title="Raport marży zakupu - szczegóły|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
					runat="server" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres"></eb:reportheader>
					<font face="Verdana" size="2">Raport podaje koszty i przychody dla rozchodów związanych z danym zakupem, bez względu na terminy rozchodów. Korekty zakupu są wykazywane jako korekty kosztu dokumentami KWPZ. Raport uwzględnia dokumenty KWPZ  z zadanego okresu i do sprzedaży z tego okresu z pominięciem ich w okresach przyszłych.</font>
					<br />
					<ea:grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
					RowsInRow="4" OnBeforeRow="Grid_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="4" runat="server" EncodeHTML="True"></ea:GridColumn>

						<ea:GridColumn Align="Left" DataMember="Numer" Caption="Dokument handlowy" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn DataMember="DokumentMagazynowyNumer" Caption="Dokument magazynowy" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn DataMember="Kontrahent" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>

						<ea:GridColumn Width="10" Align="Center" DataMember="Data" Caption=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="DokumentMagazynowyData" Caption="Data" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>

						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćZakupu" ID="ColWartZakupu" Total="Sum" Caption="Wartość/Z" Format="&lt;strong&gt;{0:n}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćZakupuTowar&#243;w" Total="Sum" Caption="towary" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćZakupuProdukt&#243;w" Total="Sum" Caption="produkty" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>

						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćSprzedaży" ID="ColWartSprzed" Total="Sum" Caption="Wartość/S" Format="&lt;strong&gt;{0:n}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćSprzedażyTowar&#243;w" Total="Sum" Caption="towary" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćSprzedażyProdukt&#243;w" Total="Sum" Caption="produkty" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćSprzedażyUsług" Total="Sum" Caption="usługi" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>

						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.Marża" Total="Sum" Caption="Marża" Format="&lt;strong&gt;{0:n}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.MarżaTowar&#243;w" Total="Sum" Caption="towary" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.MarżaProdukt&#243;w" Total="Sum" Caption="produkty" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="13" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.WartośćSprzedażyUsług" Total="Sum" Caption="usługi" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>

                        <ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.MarżaProcent" Caption="Marża %" Format="&lt;strong&gt;{0}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.MarżaTowar&#243;wProcent" Caption="towar&#243;w" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.MarżaProdukt&#243;wProcent" Caption="produkt&#243;w" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" Caption=" " Format=" " runat="server"></ea:GridColumn>

						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.NarzutProcent" Caption="Narzut %" Format="&lt;strong&gt;{0}&lt;/strong&gt;" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.NarzutTowar&#243;wProcent" Caption="towar&#243;w" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentuZakupu.NarzutProdukt&#243;wProcent" Caption="produkt&#243;w" runat="server" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" Caption=" " Format=" " runat="server" EncodeHTML="True"></ea:GridColumn>

					</Columns>
				</ea:grid>
				<font face="Verdana" size="2">
					<br />
				</font>
				<ea:Section ID="ListaKWPZ" runat="server" Width="100%" >
				<font face="Verdana" size="2">Korekty sprzedaży wynikające z korekt zakupu</font>
				<br />
				<ea:grid id="GridKor" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
					OnAfterRender="GridKor_AfterRender" OnBeforeRow="GridKor_BeforeRow">
					<Columns>
						<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="40" DataMember="DokumentMagazynowyNumer" Caption="Dokument magazynowy~Numer" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="15" DataMember="DokumentMagazynowyData" Caption="Dokument magazynowy~Data" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="WartośćWCenieZakupu" Total="Sum" Caption="Korekta|wartości zakupu|netto"
							Format="{0:n}" ID="ColZakupNettoK" EncodeHTML="True"></ea:GridColumn>
					</Columns>
				</ea:grid><br />
				<font face="Verdana" size="2">Wartość zakupu razem:
					<ea:DataLabel id="ZakupyRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>&nbsp;PLN<br />
					Zysk razem:
					<ea:DataLabel id="ZyskRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>&nbsp;PLN, 
					marża:
					<ea:DataLabel id="MarzaRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>, narzut:
					<ea:DataLabel id="NarzutRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel><br />
				</font>
				</ea:Section>
				<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter></p>
		</form>
	</body>
</html>

